/*
 * Decompiled with CFR 0.152.
 */
package com.djinfinite.manors_bounty.registries;

import com.djinfinite.manors_bounty.registries.ModBlocks;
import com.djinfinite.manors_bounty.registries.ModConfiguredFeature;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraftforge.registries.RegistryObject;

public class ModPlacedFeature {
    public static final ResourceKey<PlacedFeature> LEMON_TREE = ModPlacedFeature.createKey("lemon_tree_checked");
    public static final ResourceKey<PlacedFeature> STARFRUIT_TREE = ModPlacedFeature.createKey("lemon_tree_checked");

    public static void boostrap(BootstapContext<PlacedFeature> context) {
        ModPlacedFeature.register(context, LEMON_TREE, ModConfiguredFeature.LEMON_TREE, ModPlacedFeature.checkTree(ModBlocks.LEMON_SEED));
        ModPlacedFeature.register(context, STARFRUIT_TREE, ModConfiguredFeature.STARFRUIT_TREE, ModPlacedFeature.checkTree(ModBlocks.STARFRUIT_SEED));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("manors_bounty", name));
    }

    public static Holder.Reference<PlacedFeature> register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> featureKey, List<PlacementModifier> placement) {
        Holder.Reference feature = context.m_255420_(Registries.f_256911_).m_255043_(featureKey);
        return context.m_255272_(key, (Object)new PlacedFeature((Holder)feature, placement));
    }

    private static List<PlacementModifier> checkTree(RegistryObject<? extends Block> sapling) {
        return List.of(ModPlacedFeature.saplingFilter(sapling));
    }

    private static List<PlacementModifier> checkMangrove(RegistryObject<? extends Block> sapling, int maxWaterDepth) {
        return List.of(SurfaceWaterDepthFilter.m_191950_((int)maxWaterDepth), ModPlacedFeature.saplingFilter(sapling));
    }

    private static BlockPredicateFilter saplingFilter(RegistryObject<? extends Block> sapling) {
        return BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_190399_((BlockState)((Block)sapling.get()).m_49966_(), (Vec3i)BlockPos.f_121853_));
    }
}

